#pragma once

#include <util/generic/string.h>
#include <util/stream/file.h>
#include <util/stream/zlib.h>
#include <util/generic/hash.h>
#include <util/generic/maybe.h>

namespace NH2Log {

    struct TFileManagerOpts {
        TString OutputSuffix = "txt";

        bool AllowStdin = false;
        bool KeepExisting = false;
        bool AllowNonexisting = false;
    };


    TString ChDirToWorkspace(TStringBuf inputName);

    class TFileManager : public TMoveOnly {
        TFileManagerOpts Opts;
        TString InputName;
        TString InputPrefix;

        using TOutputFiles = THashMap<TString, THolder<IOutputStream>>;
        THolder<TOutputFiles> OutputMap = MakeHolder<TOutputFiles>();
        THolder<TFileInput> FileInput;
        THolder<TZDecompress> Gunzip;
        IInputStream* Input = &Cin;

    public:
        explicit TFileManager(const TString& inputName, const TFileManagerOpts& opts = TFileManagerOpts());

        TString GetInputName() const;

        TFileManager CreateChildManager(const TString& intermediateFile) const;

        IInputStream& GetInput() const;

        IOutputStream& GetFileOutput(const TString& fname);

        TString GetFileNameBySuffix(TStringBuf suff);

        void CloseOutput();

        TString GetDoneTag(TStringBuf name) const;

        bool HasDoneTag(TStringBuf name) const;

        void SetDoneTag(TStringBuf name);

        TVector<TString> ListFiles(TString glob) const;
    };
}
