#!/bin/bash

set -Eeuo pipefail

usage="Usage: $0 parlevel cmd args..."
parlevel="${1?$usage}"
shift
cmd=$(realpath "$(which "${1?$usage}")")
shift

cnt=0
for hst in *.search.yandex.net; do
    if [ "$cnt" -ge "$parlevel" ]; then
        wait;
        cnt=0
    else
        cnt=$(( cnt + 1 ))
    fi
    (
        echo "Processing $hst ..." >&2
        cd "$hst"
        "$cmd" "$@" 2>&1 | gawk -vhst="$hst" '{printf("(%s)\t%s\n", hst, $0)}'
        echo "Done with $hst" >&2
    )&
done

wait
