# -*- coding: utf-8 -*-
import argparse
import json
import sys
import lua_to_json


def main():
    parser = argparse.ArgumentParser(description='Convert lua balancer config to json')
    parser.add_argument('infile', type=argparse.FileType('r'), help='original lua config')
    parser.add_argument('outfile', nargs='?', type=argparse.FileType('w'), default=sys.stdout,
                        help='output file')
    parser.add_argument('--pretty', action='store_true', help='enable pretty printing')
    args = parser.parse_args()

    with args.infile as f:
        json_data = lua_to_json.load(f)

    indent = 4 if args.pretty else None

    with args.outfile as f:
        json.dump(json_data, f, indent=indent)


if __name__ == '__main__':
    main()
