# -*- coding: utf-8 -*-
import json
import pylua


__TEMPLATE = '''\
local function configgen()
{data}
return instance
end

return require('json').encode(configgen())
'''


def loads(data, lua_vars=None):
    code = __TEMPLATE.format(data=data)
    return json.loads(pylua.eval_raw(code, lua_vars))


def load(fp, lua_vars=None):
    return loads(fp.read(), lua_vars)
