#include "main.h"
#include <library/cpp/getopt/opt.h>

using NLastGetopt::TOpt;
using NLastGetopt::TOpts;
using NLastGetopt::TOptsParseResult;

void RunMain(int argc, char** argv) {
    TCounterOptions options;

    TOpts opts = TOpts::Default();
    opts.AddLongOption('i', "interface", "network interface")
        .StoreResult(&options.iface)
        .RequiredArgument()
        .Required();
    opts.AddLongOption('t', "thread-count", "thread count[only Linux]")
        .StoreResult(&options.threadCount)
        .RequiredArgument()
        .DefaultValue(1);
    opts.AddLongOption('f', "filter", "pcap filter rule")
        .StoreResult(&options.filter)
        .RequiredArgument();
    opts.AddLongOption("b", "buffer-size")
        .StoreResult(&options.bufferSize)
        .RequiredArgument()
        .DefaultValue(2097152);
    opts.AddLongOption('S', "snap-size", "snapshot length")
        .StoreResult(&options.snapSize)
        .RequiredArgument()
        .DefaultValue(262144);
    opts.AddLongOption('n', "display-timeout", "display timeout")
        .StoreResult(&options.displayTimeout)
        .RequiredArgument()
        .DefaultValue(0);
    opts.AddLongOption('p', "pretty-print").SetFlag(&options.prettyPrint).NoArgument();

    TOptsParseResult res(&opts, argc, argv);

#if not defined(_linux_)
    if (options.threadCount > 1) {
        Cerr << "Multithreaded capturing is available only on Linux\n";
        options.threadCount = 1;
    }
#endif

    RunMainCounter(options);
}

int main(int argc, char** argv) {
    try {
        RunMain(argc, argv);
    } catch (const yexception& e) {
        Cerr << e.what() << "\n";
        return 1;
    } catch (...) {
        return 1;
    }
}
