#pragma once

#include "main.h"
#include "dumper.h"

#include <unordered_set>

class TYtPcapDumper final: public IPcapDumper {
private:
    NYT::TTableWriterPtr<NYT::TNode> YtWriter_ = nullptr;
    std::unordered_set<ui64> Set_;
    ui64 OrderCounter_ = 0;
private:
    NYT::TNode CreateTableSchema();
    void WriteHeader(NYT::ITransactionPtr ytClient, const TString& fileName, const TPcapFileHeader& fileHeader);
    void Dump(const TDumpMessage& message, ui64 hash, ui64 hashInv);
public:
    TYtPcapDumper(IPcapOptions* options);
    ~TYtPcapDumper();
    void Write(const TDumpMessage& message) override;
    void Finish() override ;
};
