#!/usr/bin/env python3

import balancer.production.x.perf_tests.calculate_perf_results as calculate_perf_results


def golovan_request(signal, host, gencfg, params, end_time, interval):
    host_param = host.name if gencfg else host.cont_name
    result = calculate_perf_results.calculate(signal, host_param, params, int(end_time), interval)

    return round(result, 2)


def total_requests_summ(host, gencfg, params, end_time, interval):
    signal = 'balancer_report-report-service_total-requests_summ'

    return golovan_request(signal, host, gencfg, params, end_time, interval)


def total_fail_summ(host, gencfg, params, end_time, interval):
    signal = 'balancer_report-report-service_total-fail_summ'

    return golovan_request(signal, host, gencfg, params, end_time, interval)


def worker_cpu_usage_time_desync_summ(host, gencfg, params, end_time, interval):
    signal = 'balancer_report-worker-cpu_usage_time_desync_summ'

    return golovan_request(signal, host, gencfg, params, end_time, interval)


def worker_conts_cycle_summ(host, gencfg, params, end_time, interval):
    signal = 'balancer_report-worker-conts_cycle_summ'

    return golovan_request(signal, host, gencfg, params, end_time, interval)
