from util.generic.hash cimport THashMap
from util.generic.string cimport TString, TStringBuf

# using TLuaEval directly in .pyx is impossible
# cython converts TLuaEval().EvalRaw(...) to
#     __some_var = TLuaEval();
#     __some_var.EvalRaw(...)
# but copy assignment operator is deleted:
#
# arcadia/library/cpp/lua/eval.h:40:21: note: copy assignment operator of 'TLuaEval' is implicitly
# deleted because field 'LuaState_' has a deleted copy assignment operator
#     TLuaStateHolder LuaState_;
#                     ^
# arcadia/library/cpp/lua/wrapper.h:460:42: note: copy assignment operator of 'TLuaStateHolder' is implicitly
# deleted because field 'MyState_' has a deleted copy assignment operator
#         THolder<lua_State, TDeleteState> MyState_;
#                                          ^
# arcadia/util/generic/ptr.h:273:14: note: 'operator=' has been explicitly marked deleted here
#     THolder& operator=(const THolder&) = delete;

cdef extern from "balancer/production/x/pylua/pylua.h":
    cdef TString cpp_eval_raw(TStringBuf code, const THashMap[TString, TString]& lua_vars);


def eval_raw(code, lua_vars=None):
    if lua_vars is None:
        lua_vars = {}
    cdef THashMap[TString, TString] c_lua_vars
    for name, value in lua_vars.iteritems():
        c_lua_vars[name] = value
    return cpp_eval_raw(TString(<char *>code), c_lua_vars)
