instance = {
    monitoring = {
        answer_time_buckets = "1.0, 0.5, 0.25, 0.1, 0.05, 0.025, 0.01, 0.005, 0.001";
    };
    access_log = {
        file_name = {(access_log_file and access_log_file or './cached-access-log') .. '-' .. server_port};
        max_log_queue_size = 0;
    };
    server = {
        port = {server_port and server_port or '11112'};
        threads = {n_cpu};
        max_queue_size = {1000 * n_cpu};
    };
    modules = {
        yastatic = {
            key_builder = {
                use_sub_path = 1;
            };
            collection = {
                id = 'yastat';
                allow_sub_path = 1;
            };
            storage = {
                arenas = {n_cpu};
                memory_limit = {memory_limit};
                file_cache_size = {file_cache_size};
                block_size = '1K';
                monitoring = {
                    allowed = 1;
                    signal_prefix = 'yastat'
                };
            };
        };
    };
};
