package main

import "errors"

type StringStack []string

func NewStringStack() *StringStack {
	var s []string
	return (*StringStack)(&s)
}

func (t *StringStack) Pop() (string, error) {
	if len(*t) == 0 {
		return "", errors.New("empty stack")
	}

	buf := (*t)[len(*t)-1]
	*t = (*t)[:len(*t)-1]
	return buf, nil
}

func (t *StringStack) Push(str string) {
	*t = append(*t, str)
}

func (t StringStack) Size() int {
	return len(t)
}
