package main

type HTMLBucketData struct {
	CurrentPart int
	Storage     *StatStorage
}

func LockStatsTemplateWrapper(h *StatSuperHeap) bool {
	h.Lock()
	return true
}

func UnlockStatsTemplateWrapper(h *StatSuperHeap) bool {
	h.Unlock()
	return true
}

const HTMLBucketTemplate = `
{{define "main"}}
<html>
	<body>
		{{range $i, $data := .Storage}}
		<h3><a name="{{$i}}">Bucket {{$i}}</a></h3>
			<table>
				{{$_ := lockStats $data}}
				{{range $_, $item := $data.Heap}}
					<tr><td>{{$item.Key}}</td><td>{{$item.Code}}</td><td>{{$item.Value}}</td></tr>
				{{end}}
				{{$_ := unlockStats $data}}
			</table>
		{{end}}
		<script>window.location = (""+window.location).replace(/#[A-Za-z0-9_]*$/,'')+"#{{.CurrentPart}}"</script>
	</body>
</html>
{{end}}
`
