package main

import "strings"

type HTMLPageData struct {
	Index int
	Name  string
	Code  int
	Value int64
}

func getSucc(tmpl *HTMLPageDataTmpl, idx int) *HTMLPageData {
	if len(tmpl.Succ) > idx {
		return &tmpl.Succ[idx]
	}

	return nil
}

func getErr(tmpl *HTMLPageDataTmpl, idx int) *HTMLPageData {
	if len(tmpl.Err) > idx {
		return &tmpl.Err[idx]
	}

	return nil
}

func getStrByIdx(slice []string, idx int) string {
	if idx >= len(slice) {
		return "empty"
	}

	x := strings.Split(slice[idx], ":")
	return x[len(x)-1]
}

func LockGraphTemplateWrapper(h *GraphTopStorage) bool {
	h.Lock.Lock()
	return true
}

func UnlockGraphTemplateWrapper(h *GraphTopStorage) bool {
	h.Lock.Unlock()
	return true
}

const HTMLPageTempate = `
{{define "main"}}
<html>
    <style>
		.hostname {
			margin-top: 20px;
			font-size: 12px;
			font-weight: bold;
			text-align: right;
		}

		.main-table {
            font-size: 15pt;
            width: 100%;
        }

		.graph-table {
            font-size: 12pt;
            width: 100%;
			margin-top: 50px;
        }

		.graph-table th {
			font-size: 17px;
			font-weight: bold;
		}

		.graph-table td {
			vertical-align: top;
			width: 50%;
            word-break:break-all;
			text-align: left;
		}

        .main-table tr:nth-child(odd) .text {
            background-image: linear-gradient(to right, black 33%, rgba(255,255,255,0) 0%);
            background-position: bottom;
            background-size: 6px 1px;
            background-repeat: repeat-x;
        }

		.main-table td {
			vertical-align: top;
		}

        .text {
            width: 40%;
            word-break:break-all;
        }

        .code {
            width: 2%;
			text-align: center;
            color: #888888;
        }

        .value {
			text-align: center;
            width: 2%;
        }

        .err_value_0 { color: #9E0604; }
        .err_value_1 { color: #A40B0A; }
        .err_value_2 { color: #AB1110; }
        .err_value_3 { color: #B21716; }
        .err_value_4 { color: #B91D1C; }
        .err_value_5 { color: #C02323; }
        .err_value_6 { color: #C72B2B; }
        .err_value_7 { color: #CE3333; }
        .err_value_8 { color: #D43B3C; }
        .err_value_9 { color: #DB4445; }
        .err_value_10 { color: #E24D4F; }
        .err_value_11 { color: #E95658; }
        .err_value_12 { color: #F06063; }
        .err_value_13 { color: #F76B6D; }
        .err_value_14 { color: #FE7679; }

		.succ_value_0 { color: #1D3557; }
        .succ_value_1 { color: #274161; }
        .succ_value_2 { color: #314D6A; }
        .succ_value_3 { color: #3B5874; }
        .succ_value_4 { color: #45647D; }
        .succ_value_5 { color: #4F7087; }
        .succ_value_6 { color: #597C90; }
        .succ_value_7 { color: #63889A; }
        .succ_value_8 { color: #6C93A3; }
        .succ_value_9 { color: #769FAD; }
        .succ_value_10 { color: #80ABB6; }
        .succ_value_11 { color: #8AB7C0; }
        .succ_value_12 { color: #94C2C9; }
        .succ_value_13 { color: #9ECED3; }
        .succ_value_14 { color: #A8DADC; }

		.pointer { cursor: pointer; }
    </style>
	<script>
		window.graph2xx = new Array();
		window.graph3xx = new Array();
		window.graph4xx = new Array();
		window.graph5xx = new Array();

		function show_graph(source) {
			window.open(
				'https://yasm.yandex-team.ru/chart/hosts=ASEARCH;itype=balancer;ctype=prod;prj=l7-balancer-yastatic;signals=%7B' +
				source.join(',') + '%7D/');
		};
	</script>
	{{ $tmpl := . }}
    <body>
		<table class="main-table">
		{{ $maxLen := calcMaxLen $tmpl.Err $tmpl.Succ }}
		{{ range $i, $v := seq $maxLen }}
			{{ $succ := getSucc $tmpl $i }}
			{{ $err := getErr $tmpl $i }}
			<tr>
				<td class="text text_{{ $i }}">{{ if $err }}{{ $err.Name }}{{ end }}</td>
				<td class="code code_{{ $i }}">{{ if $err }}{{ $err.Code }}{{ end }}</td>
				<td class="value err_value_{{ $i }}">{{ if $err }}{{ $err.Value }}{{ end }}</td>
				<td class="text text_{{ $i }}">{{ if $succ }}{{ $succ.Name }}{{ end }}</td>
				<td class="code code_{{ $i }}">{{ if $succ }}{{ $succ.Code }}{{ end }}</td>
				<td class="value succ_value_{{ $i }}">{{ if $succ }}{{ $succ.Value }}{{ end }}</td>
			</tr>
		{{end}}
		</table>

		<table class="graph-table">
				<tr>
					<th onclick="show_graph(window.graph2xx);" class="pointer" title="go to graph">2xx</th>
					<th onclick="show_graph(window.graph3xx);" class="pointer" title="go to graph">3xx</th>
			  	</tr>
			{{ $_ := lockGraph $tmpl.Signals }}
			{{ $maxLen := calcMaxLen $tmpl.Signals.Signals2xx $tmpl.Signals.Signals3xx }}
			{{ range $i, $v := seq $maxLen }}
				<tr>
					<td onclick="show_graph(window.graph2xx);" class="pointer" title="go to graph">
						{{ getStrByIdx $tmpl.Signals.Signals2xx $i }}
						<script>window.graph2xx.push({{ getStrByIdx $tmpl.Signals.Signals2xx $i }});</script>
					</td>
					<td onclick="show_graph(window.graph3xx);" class="pointer" title="go to graph">
						{{ getStrByIdx $tmpl.Signals.Signals3xx $i }}
						<script>window.graph3xx.push({{ getStrByIdx $tmpl.Signals.Signals3xx $i }});</script>
					</td>
				</tr>
			{{end}}
			{{ $_ := unlockGraph $tmpl.Signals }}
		</table>
		<table class="graph-table">
				<tr>
					<th onclick="show_graph(window.graph4xx);" class="pointer" title="go to graph">4xx</th>
					<th onclick="show_graph(window.graph5xx);" class="pointer" title="go to graph">5xx</th>
			  	</tr>
			{{ $_ := lockGraph $tmpl.Signals }}
			{{ $maxLen := calcMaxLen $tmpl.Signals.Signals4xx $tmpl.Signals.Signals5xx }}
			{{ range $i, $v := seq $maxLen }}
				<tr>
					<td onclick="show_graph(window.graph4xx);" class="pointer" title="go to graph">
						{{ getStrByIdx $tmpl.Signals.Signals4xx $i }}
						<script>window.graph4xx.push({{ getStrByIdx $tmpl.Signals.Signals4xx $i }});</script>
					</td>
					<td onclick="show_graph(window.graph5xx);" class="pointer" title="go to graph">
						{{ getStrByIdx $tmpl.Signals.Signals5xx $i }}
						<script>window.graph5xx.push({{ getStrByIdx $tmpl.Signals.Signals5xx $i }});</script>
					</td>
				</tr>
			{{ end }}
			{{ $_ := unlockGraph $tmpl.Signals }}
		</table>
		<div class="hostname">
			{{ $tmpl.Host }}
		</div>
	</body>
</html>
{{end}}`
