#include "http.h"

#include <util/string/split.h>
#include <util/string/strip.h>

namespace NSv {
    TCookieVector ParseCookie(const THeaderVector& vec) noexcept {
        TCookieVector res;
        for (const auto& h : vec) {
            if (h.first == "cookie") {
                for (auto c : StringSplitter(h.second).Split(';')) {
                    if (TStringBuf n, v; c.Token().TrySplit('=', n, v)) {
                        n = StripString(n);
                        v = StripString(v);
                        if (n || v) {
                            res.emplace_back(n, v);
                        }
                    } else if (TStringBuf n = StripString(c.Token())) {
                        res.emplace_back(n, Nothing());
                    }
                }
            }
        }
        return res;
    }

    // TStreamStats GetStatsDelta(const TStreamStats& lhs, const TStreamStats& rhs) {
    //     TStreamStats res;
    //     res.BackendAttempts = rhs.BackendAttempts - lhs.BackendAttempts;
    //     res.BackendError = rhs.BackendError - lhs.BackendError;
    //     res.BackendTimeout = rhs.BackendTimeout - lhs.BackendTimeout;
    //     res.ConnRefused = rhs.ConnRefused - lhs.ConnRefused;
    //     res.ConnTimeout = rhs.ConnTimeout - lhs.ConnTimeout;
    //     res.ConnReset = rhs.ConnReset - lhs.ConnReset;
    //     for (size_t i = 0; i < res.BackendStatusCodeCategs.size(); ++i) {
    //         res.BackendStatusCodeCategs[i] = rhs.BackendStatusCodeCategs[i] - lhs.BackendStatusCodeCategs[i];
    //     }
    //     res.ConnectTime = rhs.ConnectTime;
    //     res.FullBackendTime = rhs.FullBackendTime;
    //     res.StreamStartTime = rhs.StreamStartTime;
    //     return res;
    // }
}
