#include "unistat.h"

TVector<double> NSv::THistogram::MakeBoundaries(const std::initializer_list<ui64[2]>& ranges) {
    TVector<double> bounds;
    ui64 cur = 0;
    for (auto& pair : ranges) {
        for (; cur < pair[0]; cur += pair[1]) {
            bounds.push_back(cur);
        }
    }
    bounds.push_back(cur); // an extra bucket that spans to infinity
    return bounds;
}

const TVector<double> NSv::THistogram::DefaultBoundaries = NSv::THistogram::MakeBoundaries({
    {1000, 100}, // from 0 to 1 ms in 100 us steps
    {25000, 1000}, // then to 25 ms in 1 ms steps
    {100000, 5000},
    {200000, 10000},
    {1000000, 50000},
    {2000000, 100000},
    {10000000, 500000},
    {20000000, 1000000},
    {100000000, 5000000}
});

void NSv::THistogram::operator()(NJsonWriter::TBuf& out) const {
    out.BeginList().WriteString(K_).BeginList();
    for (size_t i = 0; i < B_.size(); ++i) {
        ui64 value = V_[i];
        out.BeginList().WriteDouble(B_[i]).WriteULongLong(value).EndList();
    }
    out.EndList().EndList();
}
