#pragma once

#include <util/generic/string.h>

namespace YAML {
    class Node;
}

namespace NSv::NAppHost {
    // Convert scalars to primitives, sequences to lists, and maps to objects.
    // Unquoted strings are interpreted as bools or numbers when possible.
    TString YamlToJson(const YAML::Node&);

    // Convert a map with integer keys, corresponding to protobuf field ids, into a
    // serialized message. Lists are expanded into repeated fields, maps into nested
    // messages, and scalars are interpreted as in `YamlToJson`.
    TString YamlToProto(const YAML::Node&);
}
