#include <balancer/serval/contrib/cone/cone.hh>
#include <balancer/serval/core/config.h>

#include <util/random/normal.h>

static NSv::TAction Delay(const YAML::Node& args, NSv::TAuxData&) {
    CHECK_NODE(args, args.IsMap(), "an argument is required");
    auto t = NSv::Required<cone::timedelta>(args.begin()->second);
    auto d = NSv::Optional<cone::timedelta>(args["stddev"], cone::timedelta::zero());
    return [t, d](NSv::IStreamPtr&) {
        return cone::sleep_for(t + cone::timedelta((ui64)std::abs(NormalRandom<double>(0, d.count()))));
    };
}

SV_DEFINE_ACTION("delay", Delay);
