#pragma once

#include <balancer/kernel/module/module.h>

namespace NSrvKernel {
    class TEventWaker;
}

namespace NBalancerServer {
    struct TCallbackEnv {
        NSrvKernel::TEventWaker* EventWaker = nullptr;
    };

    using TModuleCallback = std::function<NSrvKernel::TError(const NSrvKernel::TConnDescr&, const TCallbackEnv&)>;

    class TCallbackModuleHandle
        : public NSrvKernel::IModuleHandle
    {
    public:
        explicit TCallbackModuleHandle(const TModuleCallback& callback)
            : Callback_(callback)
        {
        }

        NSrvKernel::IModule* DoConstruct(const NSrvKernel::TModuleParams& mp) const override;

        const TString& DoName() const noexcept override;
    private:
        TModuleCallback Callback_;
    };
}
