#include "common.h"

#include <balancer/kernel/module/node.h>

#include <balancer/modules/accesslog/module.h>
#include <balancer/modules/http/module.h>
#include <balancer/modules/http2/module.h>
#include <balancer/modules/ipdisp/module.h>
#include <balancer/modules/shared/module.h>
#include <balancer/modules/ssl/sni.h>


using namespace NSrvKernel;

void NBalancerServer::AddCommonServerModules(NSrvKernel::TNodeFactory<NSrvKernel::IModule>& factory) {
    factory.AddHandle(NModAccessLog::Handle());
    factory.AddHandle(NModHttp::Handle());
    factory.AddHandle(NModHttp2::Handle());
    factory.AddHandle(NModIpDispatch::Handle());
    factory.AddHandle(NModShared::Handle());
    factory.AddHandle(NModSsl::SniHandle());
};
