ConfigHead = {
    module_name = 'server_callback';
    module_config = {};
};

function ConfigHead.add(self, module_name, module_config)
    if not module_config then
        return
    end

    module_config[self.module_name] = self.module_config;
    self.module_name = module_name;
    self.module_config = module_config;
end

function ConfigHead.result(self)
    res = {};
    res[self.module_name] = self.module_config;
    return res;
end

config_head = ConfigHead;

config_head:add('accesslog', accesslog);

config_head:add('http', {
    server_mode = true;
    use_pico_parser = true;
    maxlen = maxlen;
    maxreq = maxreq;
});

config_head:add('http2', {
    allow_http2_without_ssl = true;
    allow_sending_trailers = true;
});

config_head:add('shared', {
    uuid = shared_uuid;
});

addrs = {};
ipdispatch = {};

if port > 0 then
    addrs[#addrs + 1] = { ip = "::"; port = port; };
    addrs[#addrs + 1] = { ip = "localhost"; port = port; };

    http = config_head:result();
    http['port'] = port;

    ipdispatch.http = http;
end

if ssl_port > 0  then
    addrs[#addrs + 1] = { ip = "::", port = ssl_port; };
    addrs[#addrs + 1] = { ip = "localhost", port = ssl_port; };
    
    https = {
        port = ssl_port;
        ssl_sni = ssl_sni;
    };

    if port > 0 then
        https.ssl_sni['shared'] = {
            uuid = shared_uuid;
        };
    else
        https.ssl_sni[config_head.module_name] = config_head.module_config;
    end

    ipdispatch.https = https;
end

instance = {
    addrs = addrs;

    ipdispatch = ipdispatch;
}; -- instance
