#include "raw_socket_io.h"

namespace NBalancerServer::NTesting {

TRawSocketIO::TRawSocketIO(const TString& host, ui32 port, TCont* cont, TInstant deadline)
    : Address_(new TNetworkAddress(host, port))
    , Cont_(cont)
    , Deadline_(deadline)
{
    TIOStatus(NCoro::ConnectD(Cont_, Socket_, *Address_, deadline)).Check();
}

void TRawSocketIO::DoWrite(const void* buf, size_t len) {
    auto r = NCoro::WriteD(Cont_, Socket_, buf, len, Deadline_);
    if (r.Status() == ETIMEDOUT) {
        ythrow yexception() << "write timeout";
    }
    r.Checked();
}

size_t TRawSocketIO::DoRead(void* buf, size_t len) {
    auto r = NCoro::ReadD(Cont_, Socket_, buf, len, Deadline_);
    if (r.Status() == ETIMEDOUT) {
        ythrow yexception() << "read timeout";
    }
    return r.Checked();
}

}  // namespace NBalancerServer::NTesting

