#pragma once

#include <library/cpp/coroutine/engine/network.h>

#include <library/cpp/http/io/stream.h>

#include <util/network/socket.h>

namespace NBalancerServer::NTesting {

class TRawSocketIO: public IInputStream, public IOutputStream {
public:
    TRawSocketIO(const TString& host, ui32 port, TCont* cont, TInstant deadline);

    void DoWrite(const void* buf, size_t len) override;

    size_t DoRead(void* buf, size_t len) override;

private:
    THolder<TNetworkAddress> Address_;
    TSocketHolder Socket_;

    TCont* Cont_;
    const TInstant Deadline_;
};

}  // namespace NBalancerServer::NTesting

