function gen_backend(port)
    return {
        proxy = {
            host = "localhost"; port = port;
            connect_timeout = "5s"; backend_timeout = "5s";
            resolve_timeout = "1s";
        };
    };
end

instance = {
    set_no_file = false;
    addrs = {
        { ip = "localhost"; port = port; };
    };
    admin_addrs = {
        { ip = "localhost"; port = admin_port; };
    };

    http = {
        maxreq = 64 * 1024; maxlen = 64 * 1024;
        ipdispatch = {
            admin = {
                ip = "localhost"; port = admin_port;
                admin = {};
            };
            default = {
                balancer2 = {
                    by_name_policy = {
                        name = "backend";
                        unique_policy = {};
                    };

                    fast_attempts = fast_attempts;
                    fast_503 = fast_503;

                    connection_attempts = connection_attempts;

                    attempts = attempts or 1;

                    rr = {
                        randomize_initial_state = false;
                        backend = gen_backend(backend_port);
                        second_backend = gen_backend(second_backend_port);
                    }; -- balancer2/rr
                }; -- balancer2
            }; -- ipdispatch/defaul
        }; -- ipdispatch
    }; -- http
}; -- instance
