ciphers = ciphers or "kEECDH:kRSA+AES128:kRSA:+3DES:RC4:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2";
backend_timeout = backend_timeout or "5s";

function file_path(file_name)
    return cert_dir .. "/" .. file_name
end

cert = cert or file_path("default.crt");
priv = priv or file_path("default.key");
ca = ca or file_path("root_ca.crt");

instance = {
    thread_mode = thread_mode; set_no_file = false;

    addrs = {
        { ip = "localhost"; port = port; };
    };
    admin_addrs = {
        { ip = "localhost"; port = admin_port; };
    };
    unistat = {
        addrs = {
            { ip = "localhost"; port = stats_port; disabled = 0; }
        };
    };

    workers = workers;

    ipdispatch = {
        test = {
            ip = "localhost";
            port = port;
            errorlog = {
                log = errorlog;
                ssl_sni = {
                    contexts = {
                        default = {
                            cert = cert; priv = priv; ca = ca;
                            ciphers = ciphers;
                        }; -- default
                    }; -- contexts
                    http = {
                        maxlen = 65536; maxreq = 65536;
                        accesslog = {
                            log = accesslog;
                            report = {
                                uuid = "total";
                                threshold = {
                                    pass_timeout = pass_timeout;
                                    recv_timeout = recv_timeout;
                                    lo_bytes = lo_bytes;
                                    hi_bytes = hi_bytes;
                                    proxy = {
                                        host = 'localhost'; port = backend_port;
                                        backend_timeout = backend_timeout;
                                        connect_timeout = "1s"; resolve_timeout = "1s";
                                        fail_on_5xx = false;
                                    }; -- proxy
                                }; -- threshold
                            }; -- report
                        }; -- accesslog
                    }; -- http
                }; -- ssl_sni
            }; -- errorlog
        }; -- test
    }; -- ipdispatch
}; -- instance
