#include "options.h"

#include <balancer/yt/log-tool/controller/controller.h>

#include <util/stream/output.h>
#include <util/generic/string.h>

#include <util/datetime/base.h>

template<typename TInputFormat>
void RunController(const NBalancerYt::TOptions& opts) {
    NYT::TMapReduceOperationSpec mapReduce;
    if (opts.MapJobCount) {
        mapReduce.MapJobCount(opts.MapJobCount);
    }
    if (opts.DataSizePerMapJob) {
        mapReduce.DataSizePerMapJob(opts.DataSizePerMapJob);
    }
    if (opts.ReduceJobCount) {
        mapReduce.PartitionCount(opts.ReduceJobCount);
    }
    if (opts.DataSizePerReduceJob) {
        mapReduce.PartitionDataSize(opts.DataSizePerReduceJob);
    }
    NBalancerYt::TLogProcessController<TInputFormat> controller(opts.Server, opts.Input, opts.OutputPrefix, mapReduce);

    controller.InitSandbox();
    controller.PrepareLogs();
    controller.BuildStat();
}

int main(int argc, const char* argv[]) {
    NYT::Initialize(argc, argv);

    NBalancerYt::TOptions opts(argc, argv);
    if (opts.HamsterFormat) {
        RunController<NBalancerYt::NProto::THamsterLog>(opts);
    } else {
        RunController<NBalancerYt::NProto::TProdLog>(opts);
    }
    return 0;
}
