#pragma once

#include <library/cpp/getopt/small/last_getopt.h>

namespace NBalancerYt {
    struct TOptions {
        TString Input;
        TString OutputPrefix;
        TString Server;
        bool HamsterFormat;
        ui64 MapJobCount;
        ui64 DataSizePerMapJob;

        ui32 ReduceJobCount;
        ui64 DataSizePerReduceJob;

        TOptions() {}
        TOptions(int argc, const char** argv) {
            NLastGetopt::TOpts opts = NLastGetopt::TOpts::Default();

            opts.AddVersionOption('v');
            opts.AddLongOption('i', "input", "Input YT log")
                .RequiredArgument("PATH").StoreResult(&Input).Required();

            opts.AddLongOption('o', "output", "Output YT prefix")
                .RequiredArgument("PATH").StoreResult(&OutputPrefix).Required();

            opts.AddLongOption(0, "map-job-count", "MapJobCount option affect how many jobs will be launched")
                .RequiredArgument("uint64").StoreResult(&MapJobCount).DefaultValue(0);

            opts.AddLongOption(0, "map-data-size", "DataSizePerMapJob option affect how many jobs will be launched")
                .RequiredArgument("uint64").StoreResult(&DataSizePerMapJob).DefaultValue(0);

            opts.AddLongOption(0, "reduce-job-count", "ReduceJobCount option affect how many jobs will be launched")
                .RequiredArgument("uint32").StoreResult(&ReduceJobCount).DefaultValue(0);

            opts.AddLongOption(0, "reduce-data-size", "DataSizePerReduceJob option affect how many jobs will be launched")
                .RequiredArgument("uint64").StoreResult(&DataSizePerReduceJob).DefaultValue(0);

            opts.AddLongOption(0, "hamster", "Hamster log format").NoArgument().SetFlag(&HamsterFormat);

            opts.AddLongOption(0, "yt-proxy", "YT Proxy")
                .RequiredArgument("STRING").StoreResult(&Server).DefaultValue("hahn");

            NLastGetopt::TOptsParseResult res(&opts, argc, argv);
        }
    };
}
