#pragma once

#include <balancer/yt/log-tool/proto/schema.pb.h>

#include <util/generic/string.h>

#include <utility>

namespace NBalancerYt {
    bool TryParseProcessingTree(TStringBuf s, NBalancerYt::NProto::TProcessingTree& tree);

    template<typename THandler>
    void ProcessingTreeForeach(
        const NBalancerYt::NProto::TProcessingTree& tree,
        THandler&& handler
    ) {
        handler(tree);
        for (const auto& payload : tree.GetPayload()) {
            if (payload.HasTree()) {
                ProcessingTreeForeach(payload.GetTree(), std::forward<THandler>(handler));
            }
        }
    }
    template<typename THandler>
    void ProcessingTreeRForeach(
        const NBalancerYt::NProto::TProcessingTree& tree,
        THandler&& handler
    ) {
        handler(tree);
        for (size_t i = 0; i < tree.PayloadSize(); i++) {
            const auto& payload = tree.GetPayload(tree.PayloadSize() - i - 1);
            if (payload.HasTree()) {
                ProcessingTreeForeach(payload.GetTree(), std::forward<THandler>(handler));
            }
        }
    }
}
