#pragma once

#include <balancer/yt/log-tool/controller/common/convert.h>
#include <balancer/yt/log-tool/proto/schema.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/generic/string.h>

namespace NBalancerYt {
    template<typename TInput, typename TOutput>
    class TConvertNode: public NYT::IMapper<NYT::TTableReader<TInput>, NYT::TTableWriter<TOutput>> {
    public:
        virtual void Do(
            NYT::TTableReader<TInput>* input,
            NYT::TTableWriter<TOutput>* output) override
        {
            for (; input->IsValid(); input->Next()) {
                output->AddRow(ConvertRow<TOutput>(input->GetRow()));
            }
        }
    };
    REGISTER_MAPPER(TConvertNode<NBalancerYt::NProto::THamsterLog, NBalancerYt::NProto::TLog>);
    REGISTER_MAPPER(TConvertNode<NBalancerYt::NProto::TProdLog, NBalancerYt::NProto::TLog>);
    REGISTER_MAPPER(TConvertNode<NBalancerYt::NProto::TLog, NBalancerYt::NProto::TResolvedLog>);
    REGISTER_MAPPER(TConvertNode<NBalancerYt::NProto::THamsterLog, NBalancerYt::NProto::TResolvedLog>);
    REGISTER_MAPPER(TConvertNode<NBalancerYt::NProto::TProdLog, NBalancerYt::NProto::TResolvedLog>);
}
