#include "options.h"

#include <balancer/yt/log-tool/proto/schema.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <library/cpp/protobuf/json/proto2json.h>

#include <util/stream/output.h>
#include <util/generic/string.h>

#include <util/datetime/base.h>

using TBackendStat = NBalancerYt::NProto::TBackendStat;
using TBackendStatList = NBalancerYt::NProto::TBackendStatList;

int main(int argc, const char* argv[]) {
    NBalancerYt::TOptions options(argc, argv);
    NYT::IClientPtr client = NYT::CreateClient(options.Server);

    TBackendStatList result;

    auto reader = client->CreateTableReader<TBackendStat>(options.Input);
    for (; reader->IsValid(); reader->Next()) {
        result.AddObjects()->CopyFrom(reader->GetRow());
    }

    NProtobufJson::TProto2JsonConfig config;
    config.MapAsObject = true;
    NProtobufJson::Proto2Json(result, Cout, config);
    return 0;
}
