#pragma once

#include <library/cpp/getopt/small/last_getopt.h>

namespace NBalancerYt {
    struct TOptions {
        TString Input;
        TString Server;

        TOptions() {}
        TOptions(int argc, const char** argv) {
            NLastGetopt::TOpts opts = NLastGetopt::TOpts::Default();

            opts.AddVersionOption('v');
            opts.AddLongOption('i', "input", "Input YT log")
                .RequiredArgument("PATH").StoreResult(&Input).Required();

            opts.AddLongOption(0, "yt-proxy", "YT Proxy")
                .RequiredArgument("STRING").StoreResult(&Server).DefaultValue("hahn");

            NLastGetopt::TOptsParseResult res(&opts, argc, argv);
        }
    };
}
