#pragma once

#include <stddef.h>

#if defined(__cplusplus)
extern "C" {
#endif

typedef void * DL_SessionHandle;
typedef void * DL_ResultArrayHandle;
typedef void * DL_ResultHandle;
typedef void (* DL_ResultCallback)(const char *, DL_ResultArrayHandle);


// A Session stores local context. Words are fed one by one through NextWord,
// and the result is communicated asynchronously via ResultCallback.
// There is a Flush() function to flush the inner state and clear the context.
// (This implies an external tokenizer, both by words and by sentences.)

DL_SessionHandle DL_CreateSession(DL_ResultCallback cb, const char* language);
void DL_NextWord(DL_SessionHandle proc, const char * word);
void DL_Flush(DL_SessionHandle proc);
void DL_DestroySession(DL_SessionHandle proc);

// NOTE: besides the Session itself, all other method arguments
// are short-lived. They are guaranteed to persist only within the
// callback that receives them in arguments. Don't store them.

// The result array has a length and an element accessor
int DL_GetResultCount(DL_ResultArrayHandle resarr);
DL_ResultHandle DL_GetResultAt(DL_ResultArrayHandle resarr, int idx);

// The result describes a single analysis: normalized word form, lemma,
// lexical and inflectional features. It also has a weight (can be zero
// if the underlying engine does not support it); parses are guaranteed
// to be sorted by decreasing weight within the result array, so the most
// probable is always first
const char * DL_GetWordForm(DL_ResultHandle res);
const char * DL_GetLemma(DL_ResultHandle res);
const char * DL_GetLexicalFeatures(DL_ResultHandle res);
const char * DL_GetInflectionFeatures(DL_ResultHandle res);
float DL_GetWeight(DL_ResultHandle res);

#if defined(__cplusplus)
} // extern "C"
#endif
