#include "iface.h"

#include <dict/dictless_lemmer/dictless_lemmer.h>

using namespace NDictlessLemmer;

#if defined(_win_)
    #define EXPORT __declspec(dllexport)
#else
    #define EXPORT
#endif

#define LEMMER(x) ((TLemmer*)(x))
#define KEYS(x) ((TKeys*)(x))

typedef TDictlessLemmer::TResult TKeys;
typedef TDictlessLemmer TLemmer;

extern "C" {
    EXPORT LemmerHandle* LemmerCreate(const char* data, size_t length) {
        try {
            return new TLemmer(data, length);
        } catch (...) {
        }

        return nullptr;
    }

    EXPORT bool LemmerCompare(LemmerHandle* lemmer, const Symbol* word1, const Symbol* word2) {
        return LEMMER(lemmer)->CompareForms(reinterpret_cast<const wchar16*>(word1), reinterpret_cast<const wchar16*>(word2));
    }

    EXPORT void LemmerDelete(LemmerHandle* lemmer) {
        delete LEMMER(lemmer);
    }

    EXPORT Keys* LemmerCreateKeysForForm(LemmerHandle* lemmer, const Symbol* word) {
        try {
            THolder<TKeys> result(new TKeys());

            *result.Get() = LEMMER(lemmer)->GetSchemes(TStringType(reinterpret_cast<const wchar16*>(word)));

            return result.Release();
        } catch (...) {
        }

        return nullptr;
    }

    EXPORT void LemmerDestroyKeys(Keys* keys) {
        delete KEYS(keys);
    }

    EXPORT bool LemmerCompareKeysAndForm(LemmerHandle* lemmer, const Keys* keys, const Symbol* word) {
        Y_UNUSED(lemmer); Y_UNUSED(keys); Y_UNUSED(word);
        return false; //LEMMER(lemmer)->CompareKeysAndForm(*KEYS(keys), TStringType(word));
    }
}
