#pragma once

#include <stddef.h>

#if defined(__cplusplus)
extern "C" {
#endif

typedef void LemmerHandle;
typedef unsigned short Symbol;
typedef void Keys;

LemmerHandle* LemmerCreate(const char* data, size_t length);
bool LemmerCompare(LemmerHandle* lemmer, const Symbol* word1, const Symbol* word2);
void LemmerDelete(LemmerHandle* lemmer);

//keys face
Keys* LemmerCreateKeysForForm(LemmerHandle* lemmer, const Symbol* word);
void LemmerDestroyKeys(Keys* keys);
bool LemmerCompareKeysAndForm(LemmerHandle* lemmer, const Keys* keys, const Symbol* word);

#if defined(__cplusplus)
}
#endif
