#include "iface.h"

#include <kernel/lemmer/core/language.h>
#include <kernel/lemmer/core/lemmer.h>
#include <kernel/lemmer/core/lemmeraux.h>
#include <library/cpp/langs/langs.h>
#include <util/generic/ptr.h>

#if defined(_win_)
    #define EXPORT __declspec(dllexport)
#else
    #define EXPORT
#endif

#define ANALYSES(x) ((TWLemmaArray*)(x))
#define LEMMA(x) ((TYandexLemma*)(x))
#define FORMS(x) ((TWordformArray*)(x))
#define FORM(x) ((TYandexWordform*)(x))

extern "C" {
    EXPORT MystemAnalysesHandle* MystemAnalyze(TSymbol* word, int len) {
        try {
            THolder<TWLemmaArray> out(new TWLemmaArray);
            NLemmer::AnalyzeWord(reinterpret_cast<wchar16*>(word), len, *out.Get(), TLangMask(LANG_RUS));
            return out.Release();
        } catch (...) {
        }
        return nullptr;
    }

    EXPORT void MystemDeleteAnalyses(MystemAnalysesHandle* analyses) {
        delete ANALYSES(analyses);
    }

    EXPORT int MystemAnalysesCount(MystemAnalysesHandle* analyses) {
        return ANALYSES(analyses)->size();
    }

    EXPORT MystemLemmaHandle* MystemLemma(MystemAnalysesHandle* analyses, int i) {
        try {
            return &ANALYSES(analyses)->at(i);
        } catch (...) {
        }
        return nullptr;
    }

    EXPORT TSymbol* MystemLemmaText(MystemLemmaHandle* lemma) {
        return reinterpret_cast<TSymbol*>(const_cast<wchar16*>(LEMMA(lemma)->GetText()));
    }

    EXPORT int MystemLemmaTextLen(MystemLemmaHandle* lemma) {
        return LEMMA(lemma)->GetTextLength();
    }

    EXPORT TSymbol* MystemLemmaForm(MystemLemmaHandle* lemma) {
        return reinterpret_cast<TSymbol*>(const_cast<wchar16*>(LEMMA(lemma)->GetNormalizedForm()));
    }

    EXPORT int MystemLemmaFormLen(MystemLemmaHandle* lemma) {
        return LEMMA(lemma)->GetNormalizedFormLength();
    }

    EXPORT int MystemLemmaQuality(MystemLemmaHandle* lemma) {
        return LEMMA(lemma)->GetQuality();
    }

    EXPORT char* MystemLemmaStemGram(MystemLemmaHandle* lemma) {
        return const_cast<char*>(LEMMA(lemma)->GetStemGram());
    }
    EXPORT char** MystemLemmaFlexGram(MystemLemmaHandle* lemma) {
        return const_cast<char**>(LEMMA(lemma)->GetFlexGram());
    }

    EXPORT int MystemLemmaFlexGramNum(MystemLemmaHandle* lemma) {
        return LEMMA(lemma)->FlexGramNum();
    }

    EXPORT int MystemLemmaFlexLen(MystemLemmaHandle* lemma) {
        return LEMMA(lemma)->GetFlexLen();
    }

    EXPORT int MystemLemmaRuleId(MystemLemmaHandle* lemma) {
        NLemmerAux::TYandexLemmaGetter g(*LEMMA(lemma));
        return g.GetRuleId();
    }


    EXPORT MystemFormsHandle* MystemGenerate(MystemLemmaHandle* lemma) {
        try {
            THolder<TWordformArray> out(new TWordformArray);
            NLemmer::Generate(*LEMMA(lemma), *out.Get());
            return out.Release();
        } catch (...) {
        }
        return nullptr;
    }

    EXPORT void MystemDeleteForms(MystemFormsHandle* forms) {
        delete FORMS(forms);
    }

    EXPORT int MystemFormsCount(MystemFormsHandle* forms) {
        return FORMS(forms)->size();
    }

    EXPORT MystemFormHandle* MystemForm(MystemFormsHandle* forms, int i) {
        try {
            return &FORMS(forms)->at(i);
        } catch (...) {
        }
        return nullptr;
    }

    EXPORT TSymbol* MystemFormText(MystemFormHandle* form) {
        return reinterpret_cast<TSymbol*>(const_cast<wchar16*>(FORM(form)->GetText().c_str()));
    }

    EXPORT int MystemFormTextLen(MystemFormHandle* form) {
        return FORM(form)->GetText().size();
    }

    EXPORT char* MystemFormStemGram(MystemFormHandle* form) {
        return const_cast<char*>(FORM(form)->GetStemGram());
    }

    EXPORT char** MystemFormFlexGram(MystemFormHandle* form) {
        return const_cast<char**>(FORM(form)->GetFlexGram());
    }

    EXPORT int MystemFormFlexGramNum(MystemFormHandle* form) {
        return FORM(form)->FlexGramNum();
    }
 }
