#include <bindings/c/mystem/lib/iface.h>

#include <kernel/lemmer/dictlib/grambitset.h>

#include <util/string/strip.h>
#include <util/charset/wide.h>
#include <util/stream/input.h>
#include <util/stream/output.h>


int main(int argc, const char* argv[]) {
    Y_UNUSED(argc);
    Y_UNUSED(argv);

    TString line;
    while (Cin.ReadLine(line)) {
        StripInPlace(line);
        TUtf16String wLine = UTF8ToWide(line);
        Cout << wLine;
        TVector<TSymbol> wLineBuf(wLine.size());
        Copy(wLine.cbegin(), wLine.cend(), wLineBuf.begin());
        auto hAnalyze = MystemAnalyze(wLineBuf.data(), wLineBuf.size());
        size_t lemmasCount = static_cast<size_t>(MystemAnalysesCount(hAnalyze));
        for (size_t i = 0; i < lemmasCount; ++i) {
            auto hLemma = MystemLemma(hAnalyze, i);
            TWtringBuf lemmaText{reinterpret_cast<char16_t*>(MystemLemmaText(hLemma)), static_cast<size_t>(MystemLemmaTextLen(hLemma))};
            TWtringBuf lemmaForm{reinterpret_cast<char16_t*>(MystemLemmaForm(hLemma)), static_cast<size_t>(MystemLemmaFormLen(hLemma))};
            int lemmaQuality = MystemLemmaQuality(hLemma);
            char* lemmaStemGram = MystemLemmaStemGram(hLemma);
            char** lemmaFlexGram = MystemLemmaFlexGram(hLemma);
            size_t lemmaFlexGramCount = MystemLemmaFlexGramNum(hLemma);
            auto hForms = MystemGenerate(hLemma);

            Cout
                << "\n\t" << lemmaText
                << "\t" << lemmaForm
                << "\t" << lemmaQuality
                << "\t" << TGramBitSet::FromBytes(lemmaStemGram).ToString()
                << "\t" << "[";

            for (size_t k = 0; k < lemmaFlexGramCount; ++k) {
                if (k > 0) {
                    Cout << " | ";
                }
                Cout << TGramBitSet::FromBytes(lemmaFlexGram[k]).ToString();
            }
            Cout << "]";

            size_t formsCount = static_cast<size_t>(MystemFormsCount(hForms));
            for (size_t j = 0; j < formsCount; ++j) {
                auto hForm = MystemForm(hForms, j);
                TWtringBuf formText{reinterpret_cast<char16_t*>(MystemFormText(hForm)), static_cast<size_t>(MystemFormTextLen(hForm))};
                char* formStemGram = MystemFormStemGram(hForm);
                char** formFlexGram = MystemFormFlexGram(hForm);
                size_t formFlexGramCount = MystemFormFlexGramNum(hForm);

                Cout
                    << "\n\t\t" << formText
                    << "\t" << TGramBitSet::FromBytes(formStemGram).ToString()
                    << "\t" << "[";

                for (size_t k = 0; k < formFlexGramCount; ++k) {
                    if (k > 0) {
                        Cout << " | ";
                    }
                    Cout << TGramBitSet::FromBytes(formFlexGram[k]).ToString();
                }
                Cout << "]";
            }
            Cout << Endl;

            MystemDeleteForms(hForms);
        }

        MystemDeleteAnalyses(hAnalyze);
    }

    return 0;
}
