#!/usr/bin/env python3
import sys
import json
import argparse
import subprocess


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-r', '--revision', type=int, required=True, help="Arcadia revision")
    args = parser.parse_args()

    output = subprocess.check_output(
        'ya tool sandboxctl create -N YA_PACKAGE -W -J'.split() +
        ['--desc', 'Usersplit library for all Android architectures (r{})'.format(args.revision)] +
        ['-c', 'checkout_arcadia_from_url="arcadia:/arc/trunk/arcadia@{}"'.format(args.revision)] +
        ['-c', 'packages=bindings/java/abt/abt-native/android/package.json'] +
        ['-c', 'do_not_remove_resources=True'] +
        ['-c', 'package_type=tarball'] +
        ['-c', 'build_system=distbuild'] +
        ['-c', 'build_type=release'] +
        ['-c', 'publish_package=False'] +
        ['-c', 'use_aapi_fuse=True']
    )

    resource_id = None
    j = json.loads(output.decode())
    for res in j['resources']:
        if res['type'] == 'YA_PACKAGE':
            resource_id = res['id']
    if resource_id is None:
        raise Exception("There's no resource ID!")

    archive = 'abt.r{}.tar.gz'.format(args.revision)
    download_cmd = 'wget -O {} http://proxy.sandbox.yandex-team.ru/{}'.format(archive, resource_id)
    subprocess.check_call(download_cmd.split())

    subprocess.check_call('rm -rf .deploy && mkdir .deploy', shell=True)
    subprocess.check_call('tar xf ../{}'.format(archive), cwd='.deploy', shell=True)
    subprocess.check_call('rm -rf unstripped', cwd='.deploy', shell=True)
    subprocess.check_call('echo {} >sandbox.txt'.format(resource_id), cwd='.deploy', shell=True)
    subprocess.check_call('tar cvf ../{} *'.format(archive), cwd='.deploy', shell=True)


if __name__ == "__main__":
    main()
