#include <util/string/printf.h>
#include <library/cpp/json/json_value.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/string_utils/base64/base64.h>
#include <quality/ab_testing/usersplit_lib/carrier.h>

#include "../../../src/main/native/carrierholder.h"

#include "ru_yandex_common_abt_AbtLibAndroidBrowser.h"

jclass getClassReference(JNIEnv *env, const char *classname) {
    jclass tempLocalClassRef = env->FindClass(classname);
    jclass globalRef = (jclass) env->NewGlobalRef(tempLocalClassRef);
    env->DeleteLocalRef(tempLocalClassRef);
    return globalRef;
}

#define GET_STR_ARG(arg) \
    TString arg; \
    do { \
        if (Y_LIKELY(j##arg)) { \
            const char* c##arg = env->GetStringUTFChars(j##arg, nullptr); \
            arg = TString(c##arg); \
            env->ReleaseStringUTFChars(j##arg, c##arg); \
        } \
    } while(0);

TString getString(JNIEnv *env, jobjectArray jarray, int index) {
    auto jstr = (jstring) env->GetObjectArrayElement(jarray, index);
    auto cstr = env->GetStringUTFChars(jstr, nullptr);
    auto str = TString(cstr);
    env->ReleaseStringUTFChars(jstr, cstr);
    return str;
}

void getInfo(JNIEnv *env, jlong jptr, NUserSplit::TExperimentsInfo<> &info,
             jstring juuid, jlong jtimestamp, jstring jservice,
             const NUserSplit::TParamsMapping &paramsMapping,
             const NUserSplit::TClientFeaturesMapping& cfMapping) {
    TCarrierHolder *obj = (TCarrierHolder *) jptr;
    GET_STR_ARG(service);
    GET_STR_ARG(uuid);

    NUserSplit::TRequestParams params;
    params.Uuid = uuid;
    params.Service = service;
    params.RegionId = 0;
    params.Timestamp = jtimestamp;
    params.ParamsMapping = std::move(paramsMapping);
    params.CfMapping = std::move(cfMapping);
    obj->Classify(params, info);
}

[[deprecated]]
jlong
Java_ru_yandex_common_abt_AbtLib_create__Ljava_lang_String_2(JNIEnv *env, jclass, jstring jpath) {
    try {
        const char *path = env->GetStringUTFChars(jpath, nullptr);
        TCarrierHolder *obj = new TCarrierHolder(TString(path));
        env->ReleaseStringUTFChars(jpath, path);
        return (long) obj;
    } catch (yexception e) {
        jclass jruntimeException = getClassReference(env, "java/lang/RuntimeException");
        env->ThrowNew(jruntimeException, e.what());
        return 0;
    }
}

jlong
Java_ru_yandex_common_abt_AbtLib_create__IJJ(JNIEnv *env, jclass, jint fd, jlong offset, jlong length) {
    try {
        TCarrierHolder *obj = new TCarrierHolder(fd, offset, length);
        return (long) obj;
    } catch (yexception e) {
        jclass jruntimeException = getClassReference(env, "java/lang/RuntimeException");
        env->ThrowNew(jruntimeException, e.what());
        return 0;
    }
}

[[deprecated]]
jobjectArray
Java_ru_yandex_common_abt_AbtLib_classifyAndGetBrowserParamsData__JLjava_lang_String_2Ljava_lang_String_2JJILjava_lang_String_2Ljava_lang_String_2JJLjava_lang_String_2IJJJLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2JIJLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2(JNIEnv *env, jobject, jlong jptr, jstring jhandler,
                                                       jstring juuid, jlong jtimestamp, jlong jage, jint jbuildNumber,
                                                       jstring jchannel, jstring jcountry, jlong jfirstInstallDate,
                                                       jlong jfirstUpdateDate, jstring jformFactor, jint jinstallBuildNumber,
                                                       jlong jinstallDate, jlong jlastInstallDate, jlong jlastUpdateDate,
                                                       jstring jlocaleLanguage, jstring jloginStatus, jstring jmanufacturer,
                                                       jstring jmodel, jstring jpackageName,
                                                       jlong jram, jint jsdkVersion, jlong jstartDate, jstring jversionName,
                                                       jstring jplatform, jstring jservice) {
    GET_STR_ARG(channel);
    GET_STR_ARG(country);
    GET_STR_ARG(formFactor);
    GET_STR_ARG(localeLanguage);
    GET_STR_ARG(loginStatus);
    GET_STR_ARG(manufacturer);
    GET_STR_ARG(model);
    GET_STR_ARG(packageName);
    GET_STR_ARG(versionName);
    GET_STR_ARG(platform);
    GET_STR_ARG(handler);
    auto installDate = Sprintf("%ld", (long)jinstallDate);

    NUserSplit::TParamsMapping paramsMapping;
    paramsMapping.Strings["browser__build_types"] = channel;
    paramsMapping.Strings["browser__app_versions"] = versionName;
    paramsMapping.Strings["browser__platforms"] = platform;
    paramsMapping.Strings["browser__device_types"] = formFactor;
    paramsMapping.Strings["browser__geo_countries"] = country;
    paramsMapping.Strings["browser__install_dates"] = installDate;

    NUserSplit::TClientFeaturesMapping cfMapping;
    cfMapping.Strings["locale_language"] = localeLanguage;
    cfMapping.Strings["login_status"] = loginStatus;
    cfMapping.Strings["manufacturer"] = manufacturer;
    cfMapping.Strings["model"] = model;
    cfMapping.Strings["package_name"] = packageName;

    cfMapping.Numbers["ram"] = jram;
    cfMapping.Numbers["sdk_version"] = jsdkVersion;
    cfMapping.Numbers["start_date"] = jstartDate;
    cfMapping.Numbers["age"] = jage;
    cfMapping.Numbers["build_number"] = jbuildNumber;
    cfMapping.Numbers["install_build_number"] = jinstallBuildNumber;
    cfMapping.Numbers["first_install_date"] = jfirstInstallDate;
    cfMapping.Numbers["last_install_date"] = jlastInstallDate;
    cfMapping.Numbers["first_update_date"] = jfirstUpdateDate;
    cfMapping.Numbers["last_update_date"] = jlastUpdateDate;

    NUserSplit::TExperimentsInfo<> info;
    getInfo(env, jptr, info, juuid, jtimestamp, jservice, paramsMapping, cfMapping);
    size_t len = info.ExperimentsList.size();
    jstring emptyString = env->NewStringUTF("");
    jclass stringClass = env->FindClass("java/lang/String");
    jobjectArray result = env->NewObjectArray(len * 3, stringClass, emptyString);
    for (size_t i = 0; i < len; ++i) {
        TString experimentParams;
        NJson::TJsonValue json;
        if (NJson::ReadJsonTree(Base64Decode(info.ExperimentsParams[i]), &json, false /*throwOnError*/)) {
            for (const auto& item: json.GetArray()) {
                auto& itemMap = item.GetMap();
                auto handlerIter = itemMap.find("HANDLER");
                if (handlerIter == itemMap.end() || handlerIter->second.GetString() != handler) {
                    continue;
                }

                auto contextIter = itemMap.find("CONTEXT");
                if (handlerIter == itemMap.end()) {
                    continue;
                }

                auto& contextMap = contextIter->second.GetMap();
                auto dataIter = contextMap.find(handler);
                if (dataIter == contextMap.end()) {
                    continue;
                }

                experimentParams = dataIter->second.GetStringRobust();
                break;
            }
        }

        env->SetObjectArrayElement(result, i, env->NewStringUTF(info.ExperimentsList[i].Id.data()));
        env->SetObjectArrayElement(result, len + i, env->NewStringUTF(experimentParams.data()));
        env->SetObjectArrayElement(result, len * 2 + i, env->NewStringUTF(
                ToString<NUserSplit::TBucket>(info.ExperimentsList[i].Bucket).data()));
    }
    return result;
}

jobjectArray
Java_ru_yandex_common_abt_AbtLib_classifyAndGetBrowserParamsData__JLjava_lang_String_2Ljava_lang_String_2JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2_3Ljava_lang_String_2_3J_3Ljava_lang_String_2_3Ljava_lang_String_2(
        JNIEnv *env, jobject, jlong jptr, jstring jhandler,
     jstring juuid, jlong jtimestamp,
     jstring jchannel, jstring jcountry, jstring jformFactor,
     jlong jinstallDate, jstring jversionName,
     jstring jplatform, jstring jservice,
     jobjectArray jintParamsKeys, jlongArray jintParamsValues,
     jobjectArray jstrParamsKeys, jobjectArray jstrParamsValues) {
    GET_STR_ARG(channel);
    GET_STR_ARG(country);
    GET_STR_ARG(formFactor);
    GET_STR_ARG(versionName);
    GET_STR_ARG(platform);
    GET_STR_ARG(handler);
    auto installDate = Sprintf("%ld", (long)jinstallDate);

    NUserSplit::TParamsMapping paramsMapping;
    paramsMapping.Strings["browser__build_types"] = channel;
    paramsMapping.Strings["browser__app_versions"] = versionName;
    paramsMapping.Strings["browser__platforms"] = platform;
    paramsMapping.Strings["browser__device_types"] = formFactor;
    paramsMapping.Strings["browser__geo_countries"] = country;
    paramsMapping.Strings["browser__install_dates"] = installDate;

    NUserSplit::TClientFeaturesMapping cfMapping;
    auto intParamsCount = env->GetArrayLength(jintParamsKeys);
    jlong* intParamsValues = env->GetLongArrayElements(jintParamsValues, nullptr);
    for (int i = 0; i < intParamsCount; ++i) {
        auto key = getString(env, jintParamsKeys, i);
        auto value = intParamsValues[i];
        cfMapping.Numbers[key] = value;
    }
    env->ReleaseLongArrayElements(jintParamsValues, intParamsValues, JNI_ABORT);

    auto strParamsCount = env->GetArrayLength(jstrParamsKeys);
    for (int i = 0; i < strParamsCount; ++i) {
        auto key = getString(env, jstrParamsKeys, i);
        auto value = getString(env, jstrParamsValues, i);
        cfMapping.Strings[key] = value;
    }

    NUserSplit::TExperimentsInfo<> info;
    getInfo(env, jptr, info, juuid, jtimestamp, jservice, paramsMapping, cfMapping);
    size_t len = info.ExperimentsList.size();
    jstring emptyString = env->NewStringUTF("");
    jclass stringClass = env->FindClass("java/lang/String");
    jobjectArray result = env->NewObjectArray(len * 3, stringClass, emptyString);
    for (size_t i = 0; i < len; ++i) {
        TString experimentParams;
        NJson::TJsonValue json;
        if (NJson::ReadJsonTree(Base64Decode(info.ExperimentsParams[i]), &json, false /*throwOnError*/)) {
            for (const auto& item: json.GetArray()) {
                auto& itemMap = item.GetMap();
                auto handlerIter = itemMap.find("HANDLER");
                if (handlerIter == itemMap.end() || handlerIter->second.GetString() != handler) {
                    continue;
                }

                auto contextIter = itemMap.find("CONTEXT");
                if (handlerIter == itemMap.end()) {
                    continue;
                }

                auto& contextMap = contextIter->second.GetMap();
                auto dataIter = contextMap.find(handler);
                if (dataIter == contextMap.end()) {
                    continue;
                }

                experimentParams = dataIter->second.GetStringRobust();
                break;
            }
        }

        env->SetObjectArrayElement(result, i, env->NewStringUTF(info.ExperimentsList[i].Id.data()));
        env->SetObjectArrayElement(result, len + i, env->NewStringUTF(experimentParams.data()));
        env->SetObjectArrayElement(result, len * 2 + i, env->NewStringUTF(
                ToString<NUserSplit::TBucket>(info.ExperimentsList[i].Bucket).data()));
    }
    return result;
}

#undef GET_STR_ARG
