# coding=utf-8

import os
import pytest
import logging
import yatest.common

import test.tests.common as tests_common

logger = logging.getLogger('test')

def test_size():
    package_file = "bindings/java/abt/abt-native/android/package.json"
    res = tests_common.run_ya_package([package_file])
    assert res.exit_code == 0, res.err

    packages = [f for f in os.listdir(res.output_root) if f.startswith('usersplit-android.') and f.endswith('.tar.gz')]
    assert len(packages) == 1, "Only single package must be built"

    package_path = os.path.join(res.output_root, packages[0])
    logger.debug("Working with package [{}]".format(package_path))

    so_found = False
    import tarfile
    with tarfile.open(package_path) as archive:
        for file in archive.getmembers():
            if file.name.startswith("jni/") and file.name.endswith("libabt-native-android.so"):
                logger.debug("Lib [{}] has size {} bytes".format(file.name, file.size))
                so_found = True
                allowed_size = 600*1024
                assert file.size < allowed_size, "Lib [{}] exceeded allowed size".format(file.name)
    assert so_found, "No libs found"
