#include "carrierholder.h"

#include <util/stream/length.h>

TCarrierHolder::TCarrierHolder(const TString &configPath) {
    TFileInput config(configPath);
    Reload(&config);
}

TCarrierHolder::TCarrierHolder(const int fd, const i64 offset, const size_t length) {
    TFile configFile(fd);
    configFile.Seek(offset, SeekDir::sSet);

    TFileInput configInput(configFile);
    TLengthLimitedInput configStream(&configInput, length);
    Carrier_.AtomicStore(new TCarrier(&configStream));
}

void TCarrierHolder::Reload(IInputStream *config) {
    Carrier_.AtomicStore(new TCarrier(config));
}

TString TCarrierHolder::Version() {
    return Carrier_.AtomicLoad()->GetVersion();
}

void TCarrierHolder::Classify(NUserSplit::TRequestParams &params, NUserSplit::TExperimentsInfo<> &info) {
    Carrier_.AtomicLoad()->Launch(params, info);
}
