#pragma once

#include <util/stream/file.h>
#include <library/cpp/threading/hot_swap/hot_swap.h>
#include <quality/ab_testing/usersplit_lib/carrier.h>

class TCarrierHolder {
public:
    struct TCarrier : TAtomicRefCount<TCarrier>, NUserSplit::TCarrier<NUserSplit::TExperimentsInfo<>> {
        using NUserSplit::TCarrier<NUserSplit::TExperimentsInfo<>>::TCarrier;
    };

    explicit TCarrierHolder(const TString &configPath);
    explicit TCarrierHolder(const int fd, const i64 offset, const size_t length);
    void Reload(IInputStream *config);
    TString Version();
    void Classify(NUserSplit::TRequestParams &params, NUserSplit::TExperimentsInfo<> &info);
private:
    THotSwap<TCarrier> Carrier_;
};
