#include "common_jni_objects.h"

jclass getClassReference(JNIEnv *env, const char *classname) {
    jclass tempLocalClassRef = env->FindClass(classname);
    jclass globalRef = (jclass) env->NewGlobalRef(tempLocalClassRef);
    env->DeleteLocalRef(tempLocalClassRef);
    return globalRef;
}
