#include <util/generic/hash_set.h>
#include <util/generic/string.h>
#include <util/stream/str.h>

#include "ru_yandex_common_abt_HaltingPointsSetHolder.h"
#include "common_jni_objects.h"

static jclass JC_RuntimeException;

void additional_onLoad(JNIEnv *env) {
    JC_RuntimeException = getClassReference(env, "java/lang/RuntimeException");
}

jlong JNICALL Java_ru_yandex_common_abt_HaltingPointsSetHolder_parse(JNIEnv * env, jclass, jstring jcontent) {
    try {
        const char *contentRaw = env->GetStringUTFChars(jcontent, nullptr);
        THashSet<TString>* obj = new THashSet<TString>();
        TString content(contentRaw);
        TStringInput inputStream(content);
        TString line;
        while (inputStream.ReadLine(line)) {
            obj->insert(line);
        }
        env->ReleaseStringUTFChars(jcontent, contentRaw);
        return (long) obj;
    } catch (yexception e) {
        env->ThrowNew(JC_RuntimeException, e.what());
        return 0;
    }
}

void JNICALL Java_ru_yandex_common_abt_HaltingPointsSetHolder_delete(JNIEnv *, jclass, jlong jptr) {
    THashSet<TString>* obj = (THashSet<TString>*)jptr;
    delete obj;
}
