package ru.yandex.common.abt;

import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * @author zador
 */
public class Abt {

    static {
        try {
            AbtLibraryLoader.loadLibrary();
        } catch (IOException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
    }

    protected long self;

    private Abt(long self) {
        if (self == 0L) {
            throw new OutOfMemoryError("Failure allocating native heap memory");
        }
        this.self = self;
    }

    public boolean isAllocated() {
        return this.self != 0L;
    }

    public Abt(final String configPath) {
        this(create(configPath));
    }

    public void delete() {
        assert isAllocated() : "Abt not loaded";
        if (self != 0L) {
            delete(self);
            self = 0L;
        }
    }

    public void reload(final String configPath) {
        assert isAllocated() : "Abt not loaded";
        reload(self, configPath);
    }

    public void reloads(final String config) {
        assert isAllocated() : "Abt not loaded";
        reloads(self, config);
    }

    public String version() {
        assert isAllocated() : "Abt not loaded";
        return version(self);
    }


    public String[] classify(String fuid,
                             String yuid,
                             String icookie,
                             String text,
                             String reqid,
                             long timestamp,
                             String ip,
                             int regionId,
                             String service,
                             String deviceType,
                             String testId,
                             String configType,
                             String uuid,
                             String mobilePlatform,
                             String browser,
                             String haltingPoints,
                             String login,
                             boolean isStaff) {
        assert isAllocated() : "Abt not loaded";
        return classify(
                self,
                fuid,
                yuid,
                icookie,
                text,
                reqid,
                timestamp,
                ip,
                regionId,
                service,
                deviceType,
                testId,
                configType,
                uuid,
                mobilePlatform,
                browser,
                haltingPoints,
                login,
                isStaff);
    }

    public String[] classifyAndGetParams(String fuid,
                                         String yuid,
                                         String icookie,
                                         String text,
                                         String reqid,
                                         long timestamp,
                                         String ip,
                                         int regionId,
                                         String service,
                                         String deviceType,
                                         String testId,
                                         String configType,
                                         String uuid,
                                         String mobilePlatform,
                                         String browser,
                                         String haltingPoints,
                                         String login,
                                         boolean isStaff,
                                         String did,
                                         String puid) {
        assert isAllocated() : "Abt not loaded";
        return classifyAndGetParams(
            self,
            fuid,
            yuid,
            icookie,
            text,
            reqid,
            timestamp,
            ip,
            regionId,
            service,
            deviceType,
            testId,
            configType,
            uuid,
            mobilePlatform,
            browser,
            haltingPoints,
            login,
            isStaff,
            did,
            puid);
    }

    private static native long create(final String configPath);

    protected static native void delete(long self);

    private static native boolean reload(long self, final String configPath);

    private static native boolean reloads(long self, final String config);

    private static native String version(long self);

    private native String[] classify(long self,
                                     String fuid,
                                     String yuid,
                                     String icookie,
                                     String text,
                                     String reqid,
                                     long timestamp,
                                     String ip,
                                     int regionId,
                                     String service,
                                     String deviceType,
                                     String testId,
                                     String configType,
                                     String uuid,
                                     String mobilePlatform,
                                     String browser,
                                     String haltingPoints,
                                     String login,
                                     boolean isStaff);

    private native String[] classifyAndGetParams(long self,
                                                 String fuid,
                                                 String yuid,
                                                 String icookie,
                                                 String text,
                                                 String reqid,
                                                 long timestamp,
                                                 String ip,
                                                 int regionId,
                                                 String service,
                                                 String deviceType,
                                                 String testId,
                                                 String configType,
                                                 String uuid,
                                                 String mobilePlatform,
                                                 String browser,
                                                 String haltingPoints,
                                                 String login,
                                                 boolean isStaff,
                                                 String did,
                                                 String puid);

    public native void getExperiments(
            long self,
            long inBuffer,
            int inBufferSize,
            long outBuffer,
            int outBufferSize,
            long haltingPointsSetPtr);

    public void getExperiments(
            long inBuffer,
            int inBufferSize,
            long outBuffer,
            int outBufferSize,
            long haltingPointsSetPtr)
    {
        getExperiments(self, inBuffer, inBufferSize, outBuffer, outBufferSize, haltingPointsSetPtr);
    }

    public native void getExperimentsBuf(
            long self,
            ByteBuffer directInBuffer,
            ByteBuffer directOutBuffer,
            long haltingPointsSetPtr);

    public void getExperimentsBuf(
            ByteBuffer directInBuffer,
            ByteBuffer directOutBuffer,
            long haltingPointsSetPtr)
    {
        getExperimentsBuf(self, directInBuffer, directOutBuffer, haltingPointsSetPtr);
    }
}
