package ru.yandex.common.abt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

/**
 * @author conterouz
 */
public class AbtLibraryLoader {
    private static final String LIBNAME = "abt";

    public static void loadLibrary() throws IOException {
        try {
            System.loadLibrary(LIBNAME);
            return;
        } catch (UnsatisfiedLinkError ignored) {
        }
        final String libFileName = System.mapLibraryName(LIBNAME);
        final File file;
        try (InputStream in = Abt.class.getClassLoader().getResourceAsStream(libFileName)) {
            if (in == null) {
                throw new IOException("Missing JNI library - " + libFileName);
            }
            final int pos = libFileName.lastIndexOf('.');
            file = File.createTempFile(libFileName.substring(0, pos), libFileName.substring(pos));
            file.deleteOnExit();
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(file.getAbsolutePath());
    }
}
