package ru.yandex.common.abt;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

import com.google.protobuf.InvalidProtocolBufferException;

import ru.yandex.experiments.TUsersplitRequestParams;
import ru.yandex.experiments.TUsersplitResult;

/**
 * @author conterouz
 */
public class AbtProtoHelper {

    public final static int IN_BUFFER_SIZE_DEFAULT = 1024 * 8;
    public final static int OUT_BUFFER_SIZE_DEFAULT = 1024 * 100;

    private static int inBufferSize = IN_BUFFER_SIZE_DEFAULT;
    private static int outBufferSize = OUT_BUFFER_SIZE_DEFAULT;

    /**
     * Set up new buffer size for protobuf interaction with JNI
     * @param newInBufferSize
     * @param newOutBufferSize
     */
    public static void setBufferSizes(int newInBufferSize, int newOutBufferSize) {
        inBufferSize = newInBufferSize;
        outBufferSize = newOutBufferSize;
    }

    public static int getInBufferSize() {
        return inBufferSize;
    }

    public static int getOutBufferSize() {
        return outBufferSize;
    }

    private static ThreadLocal<ByteBuffer> inBufferTL = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(inBufferSize));
    private static ThreadLocal<ByteBuffer> outBufferTL = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(outBufferSize));

    public final static AtomicInteger inBufferUnderflows = new AtomicInteger(0);
    public final static AtomicInteger outBufferUnderflows = new AtomicInteger(0);

    public static TUsersplitResult getExperiments(AbtWrapper abt, HaltingPointsSetHolderWrapper haltingPointsSetHolder, TUsersplitRequestParams requestParams) throws InvalidProtocolBufferException {
        int tries = 3;
        while (tries > 0) {
            tries--;
            try {
                // Reallocate buffers, if sizes changed
                ByteBuffer inBuffer = inBufferTL.get();
                if (inBuffer.limit() != inBufferSize) {
                    // reallocate
                    inBufferTL.set(inBuffer = ByteBuffer.allocateDirect(inBufferSize));
                }

                ByteBuffer outBuffer = outBufferTL.get();
                if (outBuffer.limit() != outBufferSize) {
                    // reallocate
                    outBufferTL.set(outBuffer = ByteBuffer.allocateDirect(outBufferSize));
                }

                inBuffer.clear();
                inBuffer.put(requestParams.toByteArray());
                inBuffer.flip();
                outBuffer.clear();

                abt.getExperimentsBuf(
                        inBuffer,
                        outBuffer,
                        haltingPointsSetHolder != null
                                ? haltingPointsSetHolder.getHaltingPointsSetPtr()
                                : 0L);

                return TUsersplitResult.parseFrom(outBuffer);
            } catch (IllegalStateException e) {
                // IllegalStateException indicates than output buffer to small
                int newSize = Integer.parseInt(e.getMessage());
                setBufferSizes(inBufferSize, (int) (newSize * 1.1));
                outBufferUnderflows.incrementAndGet();
            } catch (java.nio.BufferOverflowException e) {
                // input buffer to small
                int newSize = requestParams.toByteArray().length;
                setBufferSizes((int) (newSize * 1.1), outBufferSize);
                inBufferUnderflows.incrementAndGet();
            }
        }
        throw new IllegalStateException("JNI Request unsuccessful");
    }
}
