package ru.yandex.common.abt;

import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author conterouz
 */
public class AbtResourceManager {
    public static AbtResourceManager INSTANCE = new AbtResourceManager();

    private ReferenceQueue<AbtWrapper> referenceQueue = new ReferenceQueue<>();
    private Set<AbtFinalizer> references = Collections.synchronizedSet(new HashSet<>());

    private Thread autoCloseThread;

    private AbtResourceManager() {
        autoCloseThread = new Thread(() -> {
            try {
                while (true) {
                    AbtFinalizer reference = (AbtFinalizer)referenceQueue.remove();
                    references.remove(reference);
                    reference.close();
                }
            } catch (InterruptedException e) {
            }
        }, "abt-autoclose");
        autoCloseThread.setDaemon(true);
        autoCloseThread.start();
    }

    public AbtWrapper create(final String configPath) {
            AbtWrapper abt = new AbtWrapper(configPath);
            references.add(new AbtFinalizer(abt, referenceQueue));
            return abt;
    }
}
