package ru.yandex.common.abt;

import java.nio.ByteBuffer;

/**
 * @author conterouz
 */
public class AbtWrapper {
    protected final Abt abt;

    public AbtWrapper(final String configPath) {
        abt = new Abt(configPath);
    }

    public void delete() {
        abt.delete();
    }

    public void reload(final String configPath) {
        abt.reload(configPath);
    }

    public void reloads(final String config) {
        abt.reloads(config);
    }

    public String version() {
        return abt.version();
    }

    public String[] classify(String fuid,
                             String yuid,
                             String icookie,
                             String text,
                             String reqid,
                             long timestamp,
                             String ip,
                             int regionId,
                             String service,
                             String deviceType,
                             String testId,
                             String configType,
                             String uuid,
                             String mobilePlatform,
                             String browser,
                             String haltingPoints,
                             String login,
                             boolean isStaff) {
        return abt.classify(
                fuid,
                yuid,
                icookie,
                text,
                reqid,
                timestamp,
                ip,
                regionId,
                service,
                deviceType,
                testId,
                configType,
                uuid,
                mobilePlatform,
                browser,
                haltingPoints,
                login,
                isStaff);
    }

    public String[] classifyAndGetParams(String fuid,
                                         String yuid,
                                         String icookie,
                                         String text,
                                         String reqid,
                                         long timestamp,
                                         String ip,
                                         int regionId,
                                         String service,
                                         String deviceType,
                                         String testId,
                                         String configType,
                                         String uuid,
                                         String mobilePlatform,
                                         String browser,
                                         String haltingPoints,
                                         String login,
                                         boolean isStaff,
                                         String did,
                                         String puid) {
        return classifyAndGetParams(
                fuid,
                yuid,
                icookie,
                text,
                reqid,
                timestamp,
                ip,
                regionId,
                service,
                deviceType,
                testId,
                configType,
                uuid,
                mobilePlatform,
                browser,
                haltingPoints,
                login,
                isStaff,
                did,
                puid);
    }

    public void getExperiments(
            long inBuffer,
            int inBufferSize,
            long outBuffer,
            int outBufferSize,
            long haltingPointsSetPtr)
    {
        abt.getExperiments(inBuffer, inBufferSize, outBuffer, outBufferSize, haltingPointsSetPtr);
    }

    public void getExperimentsBuf(
            ByteBuffer directInBuffer,
            ByteBuffer directOutBuffer,
            long haltingPointsSetPtr)
    {
        abt.getExperimentsBuf(directInBuffer, directOutBuffer, haltingPointsSetPtr);
    }
}
