package ru.yandex.common.abt;

import java.io.File;
import java.io.IOException;

/**
 * @author conterouz
 */
public class HaltingPointsSetHolder {

    static {
        try {
            AbtLibraryLoader.loadLibrary();
        } catch (IOException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
    }

    public static final HaltingPointsSetHolder EMPTY = new HaltingPointsSetHolder(0);

    protected long self;

    private HaltingPointsSetHolder(long self) {
        this.self = self;
    }

    public HaltingPointsSetHolder(String content) {
        this(parse(content));
    }

    public void delete() {
        if (self != 0L) {
            delete(self);
            self = 0L;
        }
    }

    private static native long parse(String content);

    private static native void delete(long self);

    public long getHaltingPointsSetPtr() {
        return self;
    }
}
