package ru.yandex.common.abt;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

/**
 * @author conterouz
 */
public class HaltingPointsSetHolderFinalizer extends PhantomReference<HaltingPointsSetHolderWrapper> {
    final HaltingPointsSetHolder haltingPointsSetHolder;

    public HaltingPointsSetHolderFinalizer(HaltingPointsSetHolderWrapper referent, ReferenceQueue<? super HaltingPointsSetHolderWrapper> q) {
        super(referent, q);
        haltingPointsSetHolder = referent.haltingPointsSetHolder;
    }

    public void close() {
        if (haltingPointsSetHolder.self != 0L) {
            System.err.println("Cleaning HaltingPointsSetHolder reference");
            haltingPointsSetHolder.delete();
        }
    }
}
