package ru.yandex.common.abt;

import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author conterouz
 */
public class HaltingPointsSetResourceManager {
    public static HaltingPointsSetResourceManager INSTANCE = new HaltingPointsSetResourceManager();

    private ReferenceQueue<HaltingPointsSetHolderWrapper> referenceQueue = new ReferenceQueue<>();
    private Set<HaltingPointsSetHolderFinalizer> references = Collections.synchronizedSet(new HashSet<>());

    private Thread autoCloseThread;

    private HaltingPointsSetResourceManager() {
        autoCloseThread = new Thread(() -> {
            try {
                while (true) {
                    HaltingPointsSetHolderFinalizer reference = (HaltingPointsSetHolderFinalizer)referenceQueue.remove();
                    references.remove(reference);
                    reference.close();
                }
            } catch (InterruptedException e) {
                System.out.println("Thread Interrupted");
            }
        }, "haltingpointsset-autoclose");
        autoCloseThread.setDaemon(true);
        autoCloseThread.start();
    }

    public HaltingPointsSetHolderWrapper create(final String config) {
        HaltingPointsSetHolderWrapper abt = new HaltingPointsSetHolderWrapper(config);
        references.add(new HaltingPointsSetHolderFinalizer(abt, referenceQueue));
        return abt;
    }
}
