package ru.yandex.common.abt;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import ru.yandex.experiments.TRestrictions;
import ru.yandex.experiments.TSplitIds;
import ru.yandex.experiments.TUsersplitRequestParams;
import ru.yandex.experiments.TUsersplitResult;

/**
 * @author zador
 */
public class AbtProtobufTest {

  @Rule
  public ExpectedException thrown = ExpectedException.none();
  private String ABT_CONFIG_PATH;

  @Before
  public void setUp() throws Exception {
    final File file;
    try (InputStream in = Abt.class.getClassLoader().getResourceAsStream("usersplit2.conf")) {
      file = File.createTempFile("usersplit.", "");
      file.deleteOnExit();
      Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
    this.ABT_CONFIG_PATH = file.getAbsolutePath();
  }

  @Test
  public void testClassify() throws Exception {
    final AbtWrapper abt = new AbtWrapper(ABT_CONFIG_PATH);

    TUsersplitRequestParams request2 = TUsersplitRequestParams.newBuilder()
          .setRestrictions(
                  TRestrictions.newBuilder()
                          .setService("zen-recommender")
                          .build()
          )
          .setSplitIds(TSplitIds.newBuilder().setYuid("5142085391513315737").build())
          .build();

    HaltingPointsSetHolderWrapper haltingPointsSetHolder = new HaltingPointsSetHolderWrapper("e1\ne2\ne3");

    TUsersplitResult response = AbtProtoHelper.getExperiments(abt, haltingPointsSetHolder, request2);

    haltingPointsSetHolder.delete();

    //assertTrue(response.getFlagCount() == 1);
    //assertTrue(response.getTestBucketCount() == 1);
  }
}
